local t = Def.ActorFrame {
	SetCommand = function(self, params)
		if params.Song then
			self:GetChild("Title"):settext(params.Song:GetDisplayMainTitle());
			for i=1,table.getn(params.Entries) do
				local chi = self:GetChild(string.format("Score%i", i));
				if params.Entries[i] then
					chi:hidden(0);
					local score = PROFILEMAN:GetMachineProfile():GetHighScoreList(params.Song,params.Entries[i]):GetHighScores();
					if table.getn(score)>0 then
						score = score[1];
						local nam = score:GetName();
						if nam == "" then
							nam = "----";
						end;
						chi:settext(nam.."\n"..string.format("%.2f%s", score:GetPercentDP()*100.0, "%"));
					else
						chi:hidden(1);
					end;
				else
					chi:hidden(1);
				end;
			end;
		else
			self:GetChild("Title"):settext(params.Course:GetDisplayFullTitle());
			for i=1,table.getn(params.Entries) do
				local chi = self:GetChild(string.format("Score%i", i));
				if params.Entries[i] then
					chi:hidden(0);
					local score = PROFILEMAN:GetMachineProfile():GetHighScoreList(params.Course,params.Entries[i]):GetHighScores();
					if table.getn(score)>0 then
						score = score[1];
						local nam = score:GetName();
						if nam == "" then
							nam = "----";
						end;
						chi:settext(nam.."\n"..string.format("%.2f%s", score:GetPercentDP()*100.0, "%"));
					else
						chi:hidden(1);
					end;
				else
					chi:hidden(1);
				end;
			end;
		end;
	end;
	
	children = {
		LoadActor("_ScreenRanking list item");
		Def.BitmapText {
			Name="Title";
			Font="ScreenRanking list title";
			OnCommand=cmd(x,-210;maxwidth,160;shadowlength,2);
		};
		Def.BitmapText {
			Name="Score1";
			Font="ScreenRanking list score";
			OnCommand=cmd(x,-54;zoom,0.7;shadowlength,0;hidden,1);
		};
		Def.BitmapText {
			Name="Score2";
			Font="ScreenRanking list score";
			OnCommand=cmd(x,46;zoom,0.7;shadowlength,0;hidden,1);
		};
		Def.BitmapText {
			Name="Score3";
			Font="ScreenRanking list score";
			OnCommand=cmd(x,146;zoom,0.7;shadowlength,0;hidden,1);
		};
		Def.BitmapText {
			Name="Score4";
			Font="ScreenRanking list score";
			OnCommand=cmd(x,246;zoom,0.7;shadowlength,0;hidden,1);
		};
	};
};

return t;
